# 史记目录

本示例旨在使用 `luatex-cn` 宏包重现清代《四库全书》风格的目录排版。

## 来源与背景
- **原件参考**：[Internet Archive](https://archive.org/details/06054495.cn/page/n81/mode/2up)
- **年代**：清代（乾隆时期）
- **版本特色**：参考北四阁本（文渊阁、文溯阁、文津阁、文源阁）格式。

## 排版特点
- **标准行款**：严格遵循“八行，每行二十一字”的传统规范。
- **注文双行**：注文采用小字双行排列。
- **版面细节**：
    - **白口**：版心无黑线（白口）。
    - **四周双边**：版面四周有双实线边框。
    - **单鱼尾**：版心下端带有单个鱼尾装饰。
    - **朱丝栏/乌丝栏**：虽然原件可能是朱丝栏，本示例演示了如何通过配置切换。
- **封面与装订**：虽然在 LaTeX 中主要处理排版，但本示例旨在配合包背装的物理装订需求。

## 我们做了什么
1.  **风格适配**：通过配置宏包参数，实现了北四阁本特有的版匡高度（22.3厘米）与宽度（15.3厘米）比例。
2.  **目录逻辑**：测试了在严格行款限制下，目录项与页码的自动对应。
3.  **鱼尾模组**：调用了自定义的鱼尾绘制模组，确保版心文字与装饰符号的完美融合。